Imports EJRandomOrgConsumer.StructuresAndEnums
Imports System.ComponentModel

''' <summary>
''' Provides methods and properties for consuming the HTTP service at random.org that indicates the bit quota currently allocated to the IP address of the consuming application's computer.
''' </summary>
''' <remarks></remarks>
Public Class QuotaChecker


    Private Const MaxQuantity As Short = 10000
    Private Const MaxStringLength As Byte = 20

    Private _URL As String = "http://www.random.org/quota/"
    Private _ConnectionTimeout As Integer = 10000
    Private _IPAddress As String = ""


#Region " Properties "


    ''' <summary>
    ''' Gets or sets a value specifying the URL providing the service.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Browsable(True), DefaultValue("http://www.random.org/quota/"), Description("Gets or sets a value specifying the URL providing the service.")> _
     Public Property URL() As String
        Get
            Return _URL
        End Get
        Set(ByVal value As String)
            _URL = value
        End Set
    End Property


    ''' <summary>
    ''' Gets or sets the the amount of time, in milliseconds, that must elapse before a request is considered timed-out.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Browsable(True), DefaultValue(10000), Description("Gets or sets the the amount of time, in milliseconds, that must elapse before a request is considered timed-out.")> _
    Public Property ConnectionTimeout() As Integer
        Get
            Return _ConnectionTimeout
        End Get
        Set(ByVal value As Integer)
            If value <= 0 Then
                Throw New Exception("The connection timeout must be a positive integer.")
            Else
                _ConnectionTimeout = value
            End If
        End Set
    End Property


    ''' <summary>
    ''' Gets or sets the the the IP address for the quota you are testing.  If blank, the IP address of the consuming application's computer will be used.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Browsable(True), DefaultValue(""), Description("Gets or sets the the the IP address for the quota you are testing.  If blank, the IP address of the consuming application's computer will be used.")> _
    Public Property IPAddress() As String
        Get
            Return _IPAddress
        End Get
        Set(ByVal value As String)
            Dim NormalizedIPAddress As String = NormalizeIPAddress(value)
            If value <> "" AndAlso NormalizedIPAddress = "" Then
                Throw New Exception("The specified IP address is invalid.")
            Else
                _IPAddress = NormalizedIPAddress
            End If
        End Set
    End Property


#End Region


    Public Sub New()

    End Sub


    Public Sub Dispose()


    End Sub


    ''' <summary>
    ''' Connects to the remote service, requests the number of bits remaining for the IP address of the calling routine's computer, and returns the response as an integer.
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetRemainingBits() As Integer


        Dim RemainingBits As Integer = 0

        Dim FullURL As String = ""
        Dim Response As String = ""


        Try

            'Build the full URL path, including all of the variable name/value pairs.
            FullURL = GetFullURL()

            'Request the data from the server.
            Response = RemoteData.GetPageSimple(FullURL, ConnectionTimeout)

            'Does the response contain an error (if so, it will contain a colon, as per the specification at http://random.org/clients/http/ )
            If Response.Contains(":") Then
                Throw New Exception(Response)
            Else

                'Normalize linefeeds/carriage returns.
                Response = Response.Replace(vbCrLf, vbLf).Replace(vbCr, vbLf)

                'Remove trailing linefeeds.
                While Response.EndsWith(vbLf)
                    Response = Response.Substring(0, Response.Length - 1)
                End While

                'If the response is numeric, it is our return value.
                If IsNumeric(Response) Then
                    RemainingBits = CType(Response, Integer)
                Else
                    Throw New Exception("An unknown error occurred.")
                End If

            End If

        Catch ex As Exception

            Throw

        Finally

        End Try


        Return RemainingBits


    End Function


    Private Function GetFullURL() As String


        Dim sbFullURL As New System.Text.StringBuilder()
        Dim FullURL As String = ""


        Try

            sbFullURL.Append(URL)

            sbFullURL.Append("?")
            If IPAddress.Length > 0 Then
                sbFullURL.Append("ip=")
                sbFullURL.Append(IPAddress)
                sbFullURL.Append("&")
            End If

            sbFullURL.Append("format=")
            sbFullURL.Append("plain")

            FullURL = sbFullURL.ToString()

        Catch ex As Exception

            Throw

        Finally

            sbFullURL = Nothing

        End Try


        Return FullURL


    End Function


    ''' <summary>
    ''' Returs a boolean value indicating whether the specified IP address is valid.
    ''' </summary>
    ''' <param name="IPAddress"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function IsValidIPAddress(ByVal IPAddress As String) As Boolean


        Dim IsValid As Boolean = False

        Dim BadOctetExists As Boolean = False
        Dim OctetOK As Boolean = False
        Dim Octets() As String = Nothing
        Dim CurOctetString As String
        Dim CurOctetInteger As Integer


        Try

            If IPAddress <> "" Then
                Octets = IPAddress.Split(".")
                If Not Octets Is Nothing Then

                    'Make sure we have exactly 4 octets.
                    If Octets.Length = 4 Then

                        'Cycle through each octet, checking each one.
                        For Each CurOctetString In Octets

                            'By default, we'll assume this octet is bad.
                            OctetOK = False

                            'Make sure this octet isn't a blank string.
                            If CurOctetString <> "" Then

                                'Remove leading zeros.
                                While CurOctetString.StartsWith("0") And CurOctetString <> "0"
                                    CurOctetString = CurOctetString.Substring(1, CurOctetString.Length - 1)
                                End While

                                'The octet should be between 1 and three characters.
                                If CurOctetString.Length > 0 AndAlso CurOctetString.Length <= 3 Then

                                    'Make sure the octet is numeric.
                                    If IsNumeric(CurOctetString) Then

                                        'Make sure that the octet string, when cast as an integer, is identical
                                        'to the original string (this makes sure it's not a fraction, etc.).
                                        CurOctetInteger = CType(CurOctetString, Integer)
                                        If CurOctetInteger.ToString() = CurOctetString Then

                                            'Make sure the octet is between 0 and 255.
                                            If CurOctetInteger >= 0 And CurOctetInteger <= 255 Then

                                                OctetOK = True

                                            End If

                                        End If
                                    End If
                                End If
                            End If

                            'If this octet didn't check out, we can just leave now.
                            If Not OctetOK Then
                                BadOctetExists = True
                                Exit For
                            End If

                        Next

                        'If we didn't find any bad octets, the IP address is valid.
                        If Not BadOctetExists Then
                            IsValid = True
                        End If

                    End If
                End If
            End If

        Catch ex As Exception

        End Try


        Return IsValid


    End Function


    Private Function NormalizeIPAddress(ByVal OriginalString As String) As String


        Dim NewString As String = ""

        Dim Octets() As String = Nothing
        Dim CurOctetIndex As Integer


        Try

            If IsValidIPAddress(OriginalString) Then

                Octets = OriginalString.Split(".")
                For CurOctetIndex = 0 To Octets.Length - 1
                    If CurOctetIndex > 0 Then NewString &= "."
                    NewString &= CType(Octets(CurOctetIndex), Integer).ToString()
                Next

            End If

        Catch ex As Exception

        End Try


        Return NewString


    End Function


End Class
